<?php
$pageTitle = "Artikel & Wawasan Baja Industri";
$pageDescription = "Kumpulan artikel teknis tentang baja khusus, hardening, dan tips industri terupdate.";
$showFloatingWA = true;
include 'includes/header.php';
?>

<div class="section" style="padding-top: 150px;">
    <div class="container">
        <h1 style="color: var(--accent); text-align: center; margin-bottom: 1rem;">Wawasan Industri</h1>
        <p style="text-align: center; margin-bottom: 4rem; max-width: 700px; margin-left: auto; margin-right: auto;">
            Pelajari lebih dalam tentang spesifikasi teknis, aplikasi, dan perawatan baja industri untuk hasil maksimal.
        </p>
        <div style="max-width: 600px; margin: 0 auto 4rem auto; position: relative;">
            <input type="text" id="articleSearch" placeholder="Cari artikel..."
                style="width: 100%; padding: 1rem 1.5rem; border-radius: 50px; border: 2px solid var(--accent); background: #1a1a1a; color: #fff; font-size: 1.1rem; outline: none;">
            <span style="position: absolute; right: 20px; top: 50%; transform: translateY(-50%); color: var(--accent);">
                <i class="fas fa-search"></i>
            </span>
        </div>

        <script>
            document.addEventListener('DOMContentLoaded', function () {
                const searchInput = document.getElementById('articleSearch');
                const urlParams = new URLSearchParams(window.location.search);
                const query = urlParams.get('q');

                if (query) {
                    searchInput.value = query;
                    filterArticles(query);
                }

                searchInput.addEventListener('keyup', function () {
                    filterArticles(this.value);
                });

                function filterArticles(searchValue) {
                    searchValue = searchValue.toLowerCase();
                    let cards = document.querySelectorAll('.card');

                    cards.forEach(card => {
                        let title = card.querySelector('h3').innerText.toLowerCase();
                        let desc = card.querySelector('p').innerText.toLowerCase();

                        if (title.includes(searchValue) || desc.includes(searchValue)) {
                            card.style.display = 'block';
                        } else {
                            card.style.display = 'none';
                        }
                    });
                }
            });
        </script>

        <h2 style="border-bottom: 2px solid var(--accent); padding-bottom: 0.5rem; margin-bottom: 2rem;">Product
            Spotlight</h2>
        <div class="grid">
            <div class="card">
                <h3>K110 (D2) Spec</h3>
                <p>Standar emas baja cold work dengan ketahanan aus ekstrem.</p>
                <a href="article-k110.php" style="color: var(--accent); display: block; margin-top: 1rem;">Baca Artikel
                    &rarr;</a>
            </div>
            <div class="card">
                <h3>SKD11 vs D2</h3>
                <p>Mengupas perbedaan standar Jepang dan Amerika.</p>
                <a href="article-skd11-vs-d2.php" style="color: var(--accent); display: block; margin-top: 1rem;">Baca
                    Artikel &rarr;</a>
            </div>
            <div class="card">
                <h3>VCN Steel</h3>
                <p>Ketangguhan maksimal untuk poros dan komponen mesin beban berat.</p>
                <a href="article-vcn.php" style="color: var(--accent); display: block; margin-top: 1rem;">Baca Artikel
                    &rarr;</a>
            </div>
            <div class="card">
                <h3>VCL Steel</h3>
                <p>Solusi serbaguna Chrome Moly untuk gear dan as roda.</p>
                <a href="article-vcl.php" style="color: var(--accent); display: block; margin-top: 1rem;">Baca Artikel
                    &rarr;</a>
            </div>
            <div class="card">
                <h3>EMS 45 (S45C)</h3>
                <p>Baja karbon medium: tulang punggung dunia engineering.</p>
                <a href="article-s45c.php" style="color: var(--accent); display: block; margin-top: 1rem;">Baca Artikel
                    &rarr;</a>
            </div>
            <div class="card">
                <h3>Bohler W302</h3>
                <p>Master temperatur tinggi untuk die casting dan forging.</p>
                <a href="article-w302.php" style="color: var(--accent); display: block; margin-top: 1rem;">Baca Artikel
                    &rarr;</a>
            </div>
            <div class="card">
                <h3>Bohler M303</h3>
                <p>Baja mould tahan korosi dengan polesabilitas superior.</p>
                <a href="article-m303.php" style="color: var(--accent); display: block; margin-top: 1rem;">Baca Artikel
                    &rarr;</a>
            </div>
            <div class="card">
                <h3>O1 (DF2)</h3>
                <p>Oil hardening steel yang mudah di-heat treatment.</p>
                <a href="article-oil-hardening.php" style="color: var(--accent); display: block; margin-top: 1rem;">Baca
                    Artikel &rarr;</a>
            </div>
            <div class="card">
                <h3>HSS Grades</h3>
                <p>Perbedaan M2, M35, dan M42.</p>
                <a href="article-hss-grades.php" style="color: var(--accent); display: block; margin-top: 1rem;">Baca
                    Artikel &rarr;</a>
            </div>
        </div>

        <h2
            style="border-bottom: 2px solid var(--accent); padding-bottom: 0.5rem; margin-bottom: 2rem; margin-top: 4rem;">
            Application Guides</h2>
        <div class="grid">
            <div class="card">
                <h3>Plastic Moulding</h3>
                <p>Panduan kategori baja cetakan plastik.</p>
                <a href="article-plastic-mould-steels.php"
                    style="color: var(--accent); display: block; margin-top: 1rem;">Baca Artikel &rarr;</a>
            </div>
            <div class="card">
                <h3>Cold Work</h3>
                <p>Aplikasi stamping dan punching dies.</p>
                <a href="article-cold-work-applications.php"
                    style="color: var(--accent); display: block; margin-top: 1rem;">Baca Artikel &rarr;</a>
            </div>
            <div class="card">
                <h3>Hot Forging</h3>
                <p>Material tahan pukul untuk palu tempa.</p>
                <a href="article-hot-forging-die-steels.php"
                    style="color: var(--accent); display: block; margin-top: 1rem;">Baca Artikel &rarr;</a>
            </div>
            <div class="card">
                <h3>Die Casting</h3>
                <p>Solusi heat checking untuk cetakan aluminium.</p>
                <a href="article-die-casting-steels.php"
                    style="color: var(--accent); display: block; margin-top: 1rem;">Baca Artikel &rarr;</a>
            </div>
            <div class="card">
                <h3>Memilih Mould Steel</h3>
                <p>Panduan memilih material cetakan plastik yang tepat.</p>
                <a href="article-choosing-mould-steel.php"
                    style="color: var(--accent); display: block; margin-top: 1rem;">Pelajari &rarr;</a>
            </div>
            <div class="card">
                <h3>Cold Work vs Hot Work</h3>
                <p>Memahami perbedaan fundamental.</p>
                <a href="article-cold-work-applications.php"
                    style="color: var(--accent); display: block; margin-top: 1rem;">Pelajari &rarr;</a>
            </div>
        </div>

        <h2
            style="border-bottom: 2px solid var(--accent); padding-bottom: 0.5rem; margin-bottom: 2rem; margin-top: 4rem;">
            Technical Processes</h2>
        <div class="grid">
            <div class="card">
                <h3>Steel Basics</h3>
                <p>Apa beda besi dan baja? Kenali klasifikasinya.</p>
                <a href="article-steel-basics.php" style="color: var(--accent); display: block; margin-top: 1rem;">Pelajari &rarr;</a>
            </div>
            <div class="card">
                <h3>Welding 101</h3>
                <p>Panduan dasar las Stick, MIG, dan TIG.</p>
                <a href="article-welding-basics.php" style="color: var(--accent); display: block; margin-top: 1rem;">Pelajari &rarr;</a>
            </div>
            <div class="card">
                <h3>Heat Treatment 101</h3>
                <p>Dasar-dasar hardening dan tempering.</p>
                <a href="article-heat-treatment-guide.php" style="color: var(--accent); display: block; margin-top: 1rem;">Pelajari &rarr;</a>
            </div>
            <div class="card">
                <h3>Vacuum Hardening</h3>
                <p>Teknologi hardening bersih dan minim distorsi.</p>
                <a href="article-vacuum-hardening.php"
                    style="color: var(--accent); display: block; margin-top: 1rem;">Pelajari &rarr;</a>
            </div>
            <div class="card">
                <h3>Cryogenic (-196°C)</h3>
                <p>Proses sub-zero untuk kestabilan dimensi.</p>
                <a href="article-cryogenic-treatment.php"
                    style="color: var(--accent); display: block; margin-top: 1rem;">Pelajari &rarr;</a>
            </div>
            <div class="card">
                <h3>Nitriding</h3>
                <p>Surface hardening untuk ketahanan aus permukaan.</p>
                <a href="article-nitriding-explained.php"
                    style="color: var(--accent); display: block; margin-top: 1rem;">Pelajari &rarr;</a>
            </div>
            <div class="card">
                <h3>Hardness Testing</h3>
                <p>Membaca HRC, HB, dan Vickers.</p>
                <a href="article-hardness-testing.php"
                    style="color: var(--accent); display: block; margin-top: 1rem;">Pelajari &rarr;</a>
            </div>
        </div>

        <h2
            style="border-bottom: 2px solid var(--accent); padding-bottom: 0.5rem; margin-bottom: 2rem; margin-top: 4rem;">
            Tips & Troubleshooting</h2>
        <div class="grid">
            <div class="card">
                <h3>Maintenance Baja</h3>
                <p>Cara menyimpan stok agar bebas karat.</p>
                <a href="article-steel-maintenance.php"
                    style="color: var(--accent); display: block; margin-top: 1rem;">Pelajari &rarr;</a>
            </div>
            <div class="card">
                <h3>Cacat Baja (Flaws)</h3>
                <p>Mengenal inklusi dan porositas.</p>
                <a href="article-steel-flaws.php"
                    style="color: var(--accent); display: block; margin-top: 1rem;">Pelajari &rarr;</a>
            </div>
            <div class="card">
                <h3>Machinability Guide</h3>
                <p>Tips membubut baja keras.</p>
                <a href="article-machinability-guide.php"
                    style="color: var(--accent); display: block; margin-top: 1rem;">Pelajari &rarr;</a>
            </div>
            <div class="card">
                <h3>Grinding Burn</h3>
                <p>Bahaya panas berlebih saat gerinda.</p>
                <a href="article-grinding-burn.php"
                    style="color: var(--accent); display: block; margin-top: 1rem;">Pelajari &rarr;</a>
            </div>
            <div class="card">
                <h3>Welding Repair</h3>
                <p>Panduan las perbaikan dies.</p>
                <a href="article-welding-tool-steel.php"
                    style="color: var(--accent); display: block; margin-top: 1rem;">Pelajari &rarr;</a>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>