<?php
$pageTitle = "Bohler W302 (H13) - Hot Work Tool Steel";
$pageDescription = "Keunggulan Bohler W302 untuk aplikasi die casting aluminium dan forging panas.";
$showFloatingWA = true;
include 'includes/header.php';
?>

<div class="section" style="padding-top: 150px;">
    <div class="container article-content">
        <h1 style="color: var(--accent);">Bohler W302: Master of Heat</h1>
        <p class="meta">Category: Hot Work Tool Steel | Equivalent: AISI H13, JIS SKD61</p>

        <img src="assets/heat.jpg" alt="Molten Metal"
            style="width: 100%; height: 300px; object-fit: cover; border-radius: 10px; margin: 2rem 0;">

        <h2>Spesialis Temperatur Tinggi</h2>
        <p>Bohler W302 adalah baja perkakas "Hot Work" premium. Berbeda dengan K110 yang bekerja dingin, W302 dirancang
            untuk beroperasi pada suhu tinggi di mana baja biasa akan melunak dan kehilangan kekuatannya.</p>

        <h3>Fitur Kunci</h3>
        <ul>
            <li><strong>Red Hardness:</strong> Tetap keras meskipun membara (hingga 600°C).</li>
            <li><strong>Thermal Shock Resistance:</strong> Tahan terhadap siklus panas-dingin ekstrim tanpa retak (heat
                checking).</li>
            <li><strong>Toughness:</strong> Sangat tangguh untuk menahan tekanan ledakan saat injeksi logam cair.</li>
        </ul>

        <h3>Aplikasi Utama</h3>
        <p>W302 adalah standar industri untuk:</p>
        <ol>
            <li><strong>Aluminium Die Casting Moulds:</strong> Cetakan cor aluminium (blok mesin, velg).</li>
            <li><strong>Extrusion Dies:</strong> Matras untuk ekstrusi profil aluminium.</li>
            <li><strong>Forging Dies:</strong> Palu tempa panas.</li>
            <li><strong>Plastic Moulds:</strong> Cetakan plastik yang membutuhkan ketangguhan tinggi dan poles kilap.
            </li>
        </ol>

        <div
            style="background: var(--secondary); padding: 2rem; border-left: 5px solid var(--accent); margin-top: 2rem;">
            <h3>Penting: Pre-Heating</h3>
            <p>Saat menggunakan tools dari W302, sangat disarankan melakukan pre-heating (pemanasan awal) pada dies
                sebelum operasi mesin dimulai untuk mengurangi shock termal dan memperpanjang umur dies.</p>
        </div>
    </div>
</div>

<style>
    .article-content {
        max-width: 800px;
    }

    .article-content p,
    .article-content li {
        font-size: 1.1rem;
        line-height: 1.8;
        color: #ccc;
    }

    .article-content h2,
    .article-content h3 {
        color: #fff;
        margin-top: 2rem;
    }

    .article-content .meta {
        font-size: 0.9rem;
        color: var(--accent);
        font-style: italic;
    }
</style>

<?php include 'includes/footer.php'; ?>