<?php
$pageTitle = "Baja VCN - High Tensile Machinery Steel";
$pageDescription = "Mengenal VCN (AISI 4340), baja tangguh untuk poros dan gear beban berat.";
$showFloatingWA = true;
include 'includes/header.php';
?>

<div class="section" style="padding-top: 150px;">
    <div class="container article-content">
        <h1 style="color: var(--accent);">VCN: Unmatched Toughness</h1>
        <p class="meta">Category: Machinery Steel | Equivalent: AISI 4340, DIN 1.6582</p>

        <img src="assets/hero.jpg" alt="VCN Shafts"
            style="width: 100%; height: 300px; object-fit: cover; border-radius: 10px; margin: 2rem 0;">

        <h2>Mengenal Baja VCN</h2>
        <p>VCN adalah baja paduan rendah Nickel-Chromium-Molybdenum yang dirancang khusus untuk aplikasi yang
            membutuhkan kombinasi kekuatan tarik (tensile strength) tinggi dan ketangguhan (toughness) yang luar biasa.
        </p>

        <h3>Mengapa Memilih VCN?</h3>
        <ul>
            <li><strong>Shock Resistance:</strong> Sangat tahan terhadap beban kejut atau benturan tiba-tiba.</li>
            <li><strong>Deep Hardening:</strong> Mampu dikeraskan hingga ke inti material, bahkan pada diameter besar.
            </li>
            <li><strong>Keuletan Tinggi:</strong> Tidak mudah patah (getas) meskipun sangat keras.</li>
        </ul>

        <h3>Aplikasi di Lapangan</h3>
        <p>Karena ketangguhannya, VCN menjadi material wajib untuk komponen kritis:</p>
        <ul>
            <li>As Roda (Axle Shafts) kendaraan berat.</li>
            <li>Crankshafts (Poros Engkol).</li>
            <li>Roda Gigi (Gears) transmisi beban tinggi.</li>
            <li>Komponen pesawat terbang dan alat berat.</li>
        </ul>

        <div
            style="background: var(--secondary); padding: 2rem; border-left: 5px solid var(--accent); margin-top: 2rem;">
            <h3>Perbedaan dengan VCL?</h3>
            <p>VCN memiliki kandungan <strong>Nikel</strong>, yang memberikan ketangguhan ekstra terhadap benturan
                (impact). VCL (4140) umumnya tidak mengandung nikel dalam jumlah signifikan, sehingga VCN lebih unggul
                untuk aplikasi rawan patah akibat shock load.</p>
        </div>
    </div>
</div>

<style>
    .article-content {
        max-width: 800px;
    }

    .article-content p,
    .article-content li {
        font-size: 1.1rem;
        line-height: 1.8;
        color: #ccc;
    }

    .article-content h2,
    .article-content h3 {
        color: #fff;
        margin-top: 2rem;
    }

    .article-content .meta {
        font-size: 0.9rem;
        color: var(--accent);
        font-style: italic;
    }
</style>

<?php include 'includes/footer.php'; ?>