<?php
$pageTitle = "EMS 45 / S45C - Baja Karbon Medium";
$pageDescription = "Spesifikasi baja EMS 45 atau S45C, material ekonomis untuk konstruksi mesin umum.";
$showFloatingWA = true;
include 'includes/header.php';
?>

<div class="section" style="padding-top: 150px;">
    <div class="container article-content">
        <h1 style="color: var(--accent);">EMS 45 (S45C): The Engineering Backbone</h1>
        <p class="meta">Category: Carbon Steel | Equivalent: AISI 1045, JIS S45C</p>

        <img src="assets/hero.jpg" alt="Steel Bars"
            style="width: 100%; height: 300px; object-fit: cover; border-radius: 10px; margin: 2rem 0;">

        <h2>Baja Karbon Paling Populer</h2>
        <p>EMS 45 adalah nama dagang yang umum digunakan untuk grade S45C atau AISI 1045. Ini adalah baja karbon medium
            (kandungan karbon sekitar 0.45%) yang menjadi material dasar untuk ribuan jenis komponen mesin.</p>

        <h3>Karakteristik</h3>
        <ul>
            <li><strong>Harga Ekonomis:</strong> Salah satu baja teknis dengan harga paling terjangkau.</li>
            <li><strong>Weldability Terbatas:</strong> Bisa dilas namun memerlukan pre-heating karena kandungan
                karbonnya.</li>
            <li><strong>Induction Hardening:</strong> Sangat cocok untuk dikeraskan permukaannya (surface hardening)
                agar tahan gesek, sementara intinya tetap ulet.</li>
        </ul>

        <h3>Kapan Menggunakan EMS 45?</h3>
        <p>Material ini ideal untuk aplikasi yang tidak membutuhkan kekuatan tarik ekstrem seperti VCN:</p>
        <ul>
            <li>Shaft motor listrik standar.</li>
            <li>Base plate dan komponen struktur mesin.</li>
            <li>Gear pertanian.</li>
            <li>Parts hidrolik sederhana.</li>
        </ul>

        <div
            style="background: var(--secondary); padding: 2rem; border-left: 5px solid var(--accent); margin-top: 2rem;">
            <h3>Tips Pemesinan</h3>
            <p>EMS 45 memiliki machinability (kemudahan pengerjaan) yang sangat baik. Ini menjadikannya favorit bengkel
                bubut untuk membuat one-off parts atau prototipe cepat.</p>
        </div>
    </div>
</div>

<style>
    .article-content {
        max-width: 800px;
    }

    .article-content p,
    .article-content li {
        font-size: 1.1rem;
        line-height: 1.8;
        color: #ccc;
    }

    .article-content h2,
    .article-content h3 {
        color: #fff;
        margin-top: 2rem;
    }

    .article-content .meta {
        font-size: 0.9rem;
        color: var(--accent);
        font-style: italic;
    }
</style>

<?php include 'includes/footer.php'; ?>