<?php
$pageTitle = "Bohler K110 (SKD11 / D2) - Cold Work Tool Steel";
$pageDescription = "Spesifikasi dan keunggulan Bohler K110, baja D2 legendaris untuk pisau potong dan dies.";
$showFloatingWA = true;
include 'includes/header.php';
?>

<div class="section" style="padding-top: 150px;">
    <div class="container article-content">
        <h1 style="color: var(--accent);">Bohler K110: The Gold Standard</h1>
        <p class="meta">Category: Cold Work Tool Steel | Equivalent: AISI D2, JIS SKD11</p>

        <img src="assets/hero.jpg" alt="Industrial Steel"
            style="width: 100%; height: 300px; object-fit: cover; border-radius: 10px; margin: 2rem 0;">

        <h2>Apa itu K110?</h2>
        <p>Bohler K110 adalah baja perkakas jenis <strong>High Carbon, High Chromium</strong> (12% Cr) yang dikenal di
            dunia industri sebagai standar untuk ketahanan aus (wear resistance). Di pasaran umum, baja ini sering
            disebut sebagai baja D2 atau SKD11.</p>

        <h3>Karakteristik Utama</h3>
        <ul>
            <li><strong>Ketahanan Aus Tinggi:</strong> Sangat tahan terhadap abrasive wear.</li>
            <li><strong>Kekerasan Maksima:</strong> Mampu mencapai kekerasan 60-62 HRC setelah heat treatment.</li>
            <li><strong>Dimensi Stabil:</strong> Minim distorsi saat proses pengerasan.</li>
            <li><strong>Compressive Strength:</strong> Kuat menahan beban tekan tinggi.</li>
        </ul>

        <h3>Aplikasi Umum</h3>
        <p>K110 adalah pilihan utama untuk:</p>
        <ol>
            <li><strong>Cutting Tools:</strong> Pisau potong kertas, besi, dan plastik.</li>
            <li><strong>Blanking & Punching Dies:</strong> Matras pon untuk plat logam tipis hingga medium.</li>
            <li><strong>Thread Rolling Dies:</strong> Alat pembuat drat/ulir.</li>
            <li><strong>Shear Blades:</strong> Pisau guntung industri.</li>
        </ol>

        <div
            style="background: var(--secondary); padding: 2rem; border-left: 5px solid var(--accent); margin-top: 2rem;">
            <h3>Tips Heat Treatment</h3>
            <p>Untuk hasil maksimal, lakukan <em>Vacuum Hardening</em> dengan tempering minimal 2 kali untuk memastikan
                struktur martensit yang stabil dan menghilangkan sisa austenite.</p>
        </div>
    </div>
</div>

<style>
    .article-content {
        max-width: 800px;
    }

    .article-content p,
    .article-content li {
        font-size: 1.1rem;
        line-height: 1.8;
        color: #ccc;
    }

    .article-content h2,
    .article-content h3 {
        color: #fff;
        margin-top: 2rem;
    }

    .article-content .meta {
        font-size: 0.9rem;
        color: var(--accent);
        font-style: italic;
    }
</style>

<?php include 'includes/footer.php'; ?>