<?php
$pageTitle = "Cold Work vs Hot Work Tool Steels";
$pageDescription = "Panduan memahami perbedaan baja kerja dingin dan panas serta aplikasinya dalam industri.";
$showFloatingWA = true;
include 'includes/header.php';
?>

<div class="section" style="padding-top: 150px;">
    <div class="container article-content">
        <h1 style="color: var(--accent);">Cold Work vs. Hot Work Steels</h1>
        <p class="meta">Category: Technical Guide | Level: Beginner</p>

        <img src="assets/heat.jpg" alt="Metalworking"
            style="width: 100%; height: 300px; object-fit: cover; border-radius: 10px; margin: 2rem 0;">

        <h2>Suhu Operasional Adalah Kunci</h2>
        <p>Dalam dunia baja perkakas (tool steel), klasifikasi paling mendasar dibagi berdasarkan suhu kerja dari tools
            tersebut saat digunakan.</p>

        <h3>1. Cold Work Tool Steels (Baja Kerja Dingin)</h3>
        <p>Digunakan untuk aplikasi di mana suhu permukaan tool tidak melebihi 200°C selama operasi.</p>
        <ul>
            <li><strong>Contoh Grade:</strong> K110 (D2), K100 (D3), K460 (O1).</li>
            <li><strong>Karakteristik:</strong> Fokus pada kekerasan tinggi (high hardness) dan ketahanan aus (wear
                resistance).</li>
            <li><strong>Aplikasi:</strong> Pisau potong, matras pon (stamping dies), pisau serut kayu, alat ukur.</li>
        </ul>

        <h3>2. Hot Work Tool Steels (Baja Kerja Panas)</h3>
        <p>Dirancang untuk bekerja pada suhu tinggi (di atas 200°C hingga 600°C) secara terus-menerus atau siklis.</p>
        <ul>
            <li><strong>Contoh Grade:</strong> W302 (H13), W300 (H11).</li>
            <li><strong>Karakteristik:</strong> Fokus pada ketangguhan panas (red hardness), ketahanan terhadap retak
                panas (thermal fatigue/checking), dan konduktivitas panas.</li>
            <li><strong>Aplikasi:</strong> Cetakan aluminium (die casting), forging dies, ekstrusi panas.</li>
        </ul>

        <div
            style="background: var(--secondary); padding: 2rem; border-left: 5px solid var(--accent); margin-top: 2rem;">
            <h3>Kesalahan Umum</h3>
            <p>Seringkali user menggunakan baja Cold Work (seperti K110) untuk aplikasi Hot Work karena "lebih keras".
                Ini berbahaya karena baja Cold Work akan kehilangan kekerasannya (tempering back) jika terkena panas
                berlebih dan berisiko pecah seketika (catastrophic failure).</p>
        </div>
    </div>
</div>

<style>
    .article-content {
        max-width: 800px;
    }

    .article-content p,
    .article-content li {
        font-size: 1.1rem;
        line-height: 1.8;
        color: #ccc;
    }

    .article-content h2,
    .article-content h3 {
        color: #fff;
        margin-top: 2rem;
    }

    .article-content .meta {
        font-size: 0.9rem;
        color: var(--accent);
        font-style: italic;
    }
</style>

<?php include 'includes/footer.php'; ?>