<?php
$pageTitle = "Tips Memilih Baja Moulding (Cetakan Plastik)";
$pageDescription = "Panduan memilih antara P20, 2316, atau M303 untuk cetakan plastik Anda.";
$showFloatingWA = true;
include 'includes/header.php';
?>

<div class="section" style="padding-top: 150px;">
    <div class="container article-content">
        <h1 style="color: var(--accent);">Memilih Baja Moulding yang Tepat</h1>
        <p class="meta">Category: Technical Guide | Level: Intermediate</p>

        <img src="assets/hero.jpg" alt="Plastic Moulds"
            style="width: 100%; height: 300px; object-fit: cover; border-radius: 10px; margin: 2rem 0;">

        <h2>Jangan Asal Pilih Material</h2>
        <p>Biaya pembuatan mould sangat mahal, jauh lebih mahal dari harga material bajanya. Kesalahan memilih baja bisa
            berakibat retak saat produksi atau finish produk yang buruk.</p>

        <h3>Faktor Penentu</h3>

        <h4>1. Jenis Plastik (Resin)</h4>
        <ul>
            <li><strong>Non-Korosif (PP, PE, ABS):</strong> Bisa gunakan baja standar seperti P20 (2311).</li>
            <li><strong>Korosif (PVC):</strong> Wajib menggunakan Stainless Steel seperti M303 atau 2316 untuk mencegah
                karat akibat gas asam klorida.</li>
            <li><strong>Abrasif (Glass Fiber filled):</strong> Butuh baja dengan kekerasan tinggi seperti D2 atau M303
                High Hard.</li>
        </ul>

        <h4>2. Finish Produk</h4>
        <ul>
            <li><strong>Standard:</strong> P20 sudah cukup.</li>
            <li><strong>High Gloss / Cermin:</strong> Butuh baja ESR (Electro Slag Remelting) seperti 2316 ESR atau M303
                untuk hasil poles sempurna bebas pinhole.</li>
        </ul>

        <h4>3. Volume Produksi</h4>
        <p>Untuk produksi massal (jutaan shot), gunakan baja yang bisa di-hardening hingga 50 HRC ke atas (seperti
            Stavax/M303) agar parting line tidak cepat aus.</p>

        <div
            style="background: var(--secondary); padding: 2rem; border-left: 5px solid var(--accent); margin-top: 2rem;">
            <h3>Ekonomis vs Jangka Panjang</h3>
            <p>Selisih harga material P20 dan M303 mungkin terasa di awal. Tapi jika memperhitungkan biaya maintenance
                mould (pembersihan karat, poles ulang), M303 seringkali jauh lebih hemat untuk jangka panjang.</p>
        </div>
    </div>
</div>

<style>
    .article-content {
        max-width: 800px;
    }

    .article-content p,
    .article-content li {
        font-size: 1.1rem;
        line-height: 1.8;
        color: #ccc;
    }

    .article-content h2,
    .article-content h3 {
        color: #fff;
        margin-top: 2rem;
    }

    .article-content h4 {
        color: var(--accent);
        margin-top: 1.5rem;
    }

    .article-content .meta {
        font-size: 0.9rem;
        color: var(--accent);
        font-style: italic;
    }
</style>

<?php include 'includes/footer.php'; ?>